% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arranging.R
\name{arrange_}
\alias{arrange_}
\title{Arranging Functions}
\usage{
arrange_(
  .data = (.),
  ...,
  .by_group = FALSE,
  .locale = "C",
  .decreasing = FALSE
)
}
\arguments{
\item{.data}{A data frame (data.frame, data.table or tibble's tbl_df). If not
provided, the data-dot mechanism injects \code{.} as \verb{.data=} automatically.}

\item{...}{Either standard (quoted) column names of \code{data}. of formulas like
\code{~col_name} (formula-masking).}

\item{.by_group}{Logical. If \code{TRUE} rows are first arranged by the grouping
variables if any (applies only to grouped data frames). \code{FALSE} by default.}

\item{.locale}{The locale to sort character vectors in. If \code{NULL}(default),
use the \code{"dplyr.legacy_locale"} option (same one as \code{\link[dplyr:arrange]{dplyr::arrange()}}),
and if not specified, it uses a \code{"C"} locale.}

\item{.decreasing}{Sort in decreasing order (no, \code{FALSE}, by default)?}
}
\value{
A similar object as \code{.data} with all columns, all attributes and
groups preserved, but row rearranged according to the specified order.
}
\description{
Functions for arranging (sorting) rows.
These are SciViews::R versions with standard evaluation
and formula-based non-standard evaluation (ending with underscore \verb{_}).
}
\details{
For the way missing data are handled, see \code{\link[dplyr:arrange]{dplyr::arrange()}}.
}
\examples{
library(svTidy)
data(mtcars, package = 'datasets')
mtcars <- data.trame::as.data.trame(mtcars)
# Standard evaluation (provide quoted names of the columns to sort)
# You cannot use desc(col) here, but must specify what you want in the
# .decreasing argument
arrange_(mtcars, 'cyl', 'disp', .decreasing = c(FALSE, TRUE))
# With formula masking, you can use desc()
arrange_(mtcars, ~cyl, ~desc(disp))
}
\seealso{
\code{\link[dplyr:arrange]{dplyr::arrange()}}
}
