% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binding.R
\name{bind_rows_}
\alias{bind_rows_}
\alias{bind_cols_}
\title{Binding Functions}
\usage{
bind_rows_(..., .id = NULL, .use_names = TRUE, .fill = TRUE)

bind_cols_(
  ...,
  .name_repair = c("unique", "universal", "check_unique", "minimal")
)
}
\arguments{
\item{...}{Data frames to bind.}

\item{.id}{The name of the column for the origin id, either names if all
other arguments are named, or numbers.}

\item{.use_names}{If \code{TRUE} (default), bind by matching names, if \code{FALSE},
bind by position. If \code{NULL}, warns if  all items do not have the same name
in the same order, and then proceeds as if \code{FALSE} (but will be as if
\code{TRUE} in the future).}

\item{.fill}{If \code{TRUE} (default), fill missing columns with \code{NA} or \code{NULL}
for missing list columns, if \code{FALSE}, do not fill.}

\item{.name_repair}{How should the name be "repaired" to avoid duplicate}
}
\value{
A data frame of the same type as the first one provided in \code{...}.
}
\description{
Functions for binding data frames by rows or columns.
These are SciViews::R versions with standard evaluation
and formula-based non-standard evaluation (ending with underscore \verb{_}).

#' \strong{Functions:}
\itemize{
\item \code{bind_rows_()} - Stack two or more data frames one on top of the other
\item \code{bind_cols_()} - Stack two or more data frames side by side
}
}
\seealso{
\code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}, \code{\link[dplyr:bind_cols]{dplyr::bind_cols()}}
}
