% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{filtering}
\alias{filtering}
\alias{filter_}
\alias{distinct_}
\alias{slice_}
\alias{slice_head_}
\alias{slice_tail_}
\title{Filter Rows and Slice Data Frames}
\usage{
filter_(.data = (.), ..., .by = NULL, .preserve = FALSE)

distinct_(.data = (.), ..., .keep_all = FALSE, .method = "auto")

slice_(.data = (.), ..., .by = NULL, .preserve = NULL)

slice_head_(.data = (.), ..., n = 1L, prop, by = NULL, sort = TRUE)

slice_tail_(.data = (.), ..., n = 1L, prop, by = NULL, sort = TRUE)
}
\arguments{
\item{.data}{A data frame (data.frame, data.table, or tibble)}

\item{...}{For \code{filter_()}: conditions as formulas (e.g., \code{~mpg > 20}).
For \code{distinct_()}: columns to use for uniqueness.
For \code{slice_()}: row positions.}

\item{.by}{A list of names of the columns to use for grouping the data.}

\item{.preserve}{Logical. When \code{TRUE}, preserve the grouping structure in
the result. When \code{FALSE} (default), recalculate grouping based on the
filtered data.}

\item{.keep_all}{Logical. For \code{distinct_()}, if \code{TRUE}, keep all columns in
the result. If \code{FALSE} (default), keep only the distinct columns.}

\item{.method}{The algorithm to use for grouping:  \code{"radix"}, \code{"hash"}, or
\code{"auto"} (by default). \code{"auto"} chose \code{"radix"} when \code{sort = TRUE} and
\code{"hash"} otherwise.}

\item{n}{Number of rows to keep}

\item{prop}{Proportion of rows to keep, between 0 and 1. Provide either \code{n},
or \code{prop} but not both simultaneously. If none is provided, \code{n = 1} is
used.
@param by A list of names of the columns to use for joining the two data
frames.}

\item{by}{A list of names of the columns to use for grouping the data.}

\item{sort}{If \code{TRUE} largest group will be shown on top.}
}
\value{
A data frame with filtered/selected rows, maintaining the same class
as the input (data.frame, data.table, or tibble).
}
\description{
Functions for subsetting rows based on conditions or by position.

These are SciViews::R versions of tidyverse functions with standard
evaluation and formula-based non-standard evaluation (ending with underscore
\verb{_}). They work with data.frame, data.table, and tibbles.

\strong{Functions:}
\itemize{
\item \code{filter_()} - Keep rows that match conditions
\item \code{distinct_()} - Keep only unique/distinct rows based on columns
\item \code{slice_()} - Select rows by position (index)
\item \code{slice_head_()} - Select first n rows or proportion
\item \code{slice_tail_()} - Select last n rows or proportion
}
}
\note{
From \{dplyr\}, the \code{slice_min()}, \code{slice_max()} and \code{slice_sample()}
functions are not added yet.
}
\examples{
library(svTidy)
data(mtcars)

# Filter rows with condition
mtcars |> filter_(~mpg > 20)

# Multiple conditions (AND logic)
mtcars |> filter_(~mpg > 20, ~cyl == 4)

# Get distinct values for columns
mtcars |> distinct_(~cyl, ~gear)

# Distinct with all columns kept
mtcars |> distinct_(~cyl, .keep_all = TRUE)

# Slice specific rows
mtcars |> slice_(1, 5, 10)

# Select first 5 rows
mtcars |> slice_head_(n = 5)

# Select last 10\% of rows
mtcars |> slice_tail_(prop = 0.1)

# Grouped filtering
mtcars |>
  group_by_(~cyl) |>
  filter_(~mpg > mean(~mpg))

}
\seealso{
\code{\link[dplyr:filter]{dplyr::filter()}}, \code{\link[dplyr:distinct]{dplyr::distinct()}}, \code{\link[dplyr:slice]{dplyr::slice()}},
\code{\link[dplyr:slice]{dplyr::slice_head()}}, \code{\link[dplyr:slice]{dplyr::slice_tail()}}
}
