% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouping.R
\name{grouping}
\alias{grouping}
\alias{group_by_}
\alias{ungroup_}
\alias{group_vars_}
\alias{group_rows_}
\alias{group_data_}
\alias{group_indices_}
\alias{group_keys_}
\alias{groups_}
\alias{group_size_}
\alias{n_groups_}
\alias{as.grouped_df}
\alias{as_grouped_df}
\alias{as.grouped_df.default}
\alias{as.grouped_df.grouped_df}
\alias{as.grouped_df.GRP_df}
\alias{print.grouped_df}
\alias{is.grouped_df}
\title{Grouping Functions and Group Metadata}
\usage{
group_by_(
  .data = (.),
  ...,
  .add = FALSE,
  .drop = NULL,
  .sort = get_collapse("sort"),
  .decreasing = FALSE,
  .na.last = TRUE,
  .return.groups = TRUE,
  .return.order = .sort,
  .method = "auto"
)

ungroup_(.data = (.), ..., .na.last = TRUE, .method = "auto")

group_vars_(.data = (.), return = "names")

group_rows_(.data = (.))

group_data_(.data = (.))

group_indices_(.data = (.), ...)

group_keys_(.data = (.), ...)

groups_(.data = (.))

group_size_(.data = (.))

n_groups_(.data = (.))

as.grouped_df(x, ...)

as_grouped_df(x, ...)

\method{as.grouped_df}{default}(x, ...)

\method{as.grouped_df}{grouped_df}(x, ...)

\method{as.grouped_df}{GRP_df}(x, ...)

\method{print}{grouped_df}(x, ...)

is.grouped_df(x, collapse = FALSE)
}
\arguments{
\item{.data}{A data frame (data.frame, data.table, or tibble)}

\item{...}{For \code{group_by_()}: grouping variables as formulas (e.g., \code{~cyl})
or character names. For \code{ungroup_()}: optional variables to remove from
grouping (if omitted, removes all grouping).}

\item{.add}{Logical. If \code{TRUE}, add new grouping variables to existing ones.
If \code{FALSE} (default), replace existing grouping.}

\item{.drop}{Logical. Should unused factor levels be dropped? Default is
\code{TRUE}, unless the data was previously grouped with \code{.drop = FALSE}.}

\item{.sort}{Logical. Should groups be sorted? Default uses the collapse
package setting.}

\item{.decreasing}{Logical. Should sorting be in decreasing order? Default
is \code{FALSE}.}

\item{.na.last}{Logical. Should \code{NA} values be sorted last? Default is \code{TRUE}.}

\item{.return.groups}{Logical. Should group information be stored? Default
is \code{TRUE}.}

\item{.return.order}{Logical. Should group order be stored? Default follows
\code{.sort}.}

\item{.method}{Character. Method for grouping: \code{"auto"} (default), \code{"hash"},
or \code{"radix"}.}

\item{return}{What to return: \code{"data"} or \code{1}, \code{"unique"} or \code{2} for unique
rows of grouping columns, \code{"names"} or \code{3} (default) for names of grouping
columns, \code{"indices"} or \code{4} for integer indices of grouping columns,
\code{"named_indices"} or \code{5} for named indices, \code{"logicial"} or \code{6} for logical
selection vector of grouping columns, or \code{"named_logical"} or \code{7} for named
logical.}

\item{x}{An object to convert to \strong{grouped_df}, or to check as such}

\item{collapse}{Logical. If \code{TRUE}, check if it is a special version of
\strong{grouped_df} build by \code{group_by_()} or \code{\link[collapse:GRP]{collapse::fgroup_by()}}, that is,
a \strong{GRP_df} object only partly compatible with an object obtained with
\code{\link[dplyr:group_by]{dplyr::group_by()}}.}
}
\value{
\itemize{
\item \code{group_by_()} returns a grouped data frame (GRP_df or grouped_df class)
\item \code{ungroup_()} returns the data frame without grouping (or with partial
grouping if specific variables removed)
\item \code{group_vars_()} returns names, data, or indices depending on \code{return} arg
\item \code{group_rows_()} returns a list of integer vectors with row indices per
group
\item \code{group_data_()} returns a tibble with grouping columns and a \code{.rows} column
\item \code{group_indices_()} returns an integer vector with group ID for each row
\item \code{group_keys_()} returns a data frame with unique grouping variable values
\item \code{groups_()} returns a list of symbols (grouping variable names)
\item \code{group_size_()} returns an integer vector with row counts per group
\item \code{n_groups_()} returns a single integer (total number of groups)
\item \code{as.grouped_df()} returns a grouped_df object
}
}
\description{
Functions for grouping data frames and accessing group metadata.

These are SciViews::R versions of tidyverse functions with standard
evaluation and formula-based non-standard evaluation (ending with underscore
\verb{_}). They work with data.frame, data.table, and tibbles.

\strong{Functions:}
\itemize{
\item \code{group_by_()} - Group data by one or more variables
\item \code{ungroup_()} - Remove grouping variables
\item \code{group_vars_()} - Get names or info about grouping variables
\item \code{group_rows_()} - Get row indices for each group
\item \code{group_data_()} - Get a tibble with grouping data and row indices
\item \code{group_indices_()} - Get group index for each row
\item \code{group_keys_()} - Get unique values of grouping variables
\item \code{groups_()} - Get grouping variables as symbols
\item \code{group_size_()} - Get number of rows in each group
\item \code{n_groups_()} - Get total number of groups
\item \code{as.grouped_df()} / \code{as_grouped_df()} - Convert to grouped_df object
\item \code{is.grouped_df()} - Test if object is a grouped_df
}
}
\examples{
library(svTidy)
data(mtcars)

# Group by single variable
mtcars |> group_by_(~cyl)

# Group by multiple variables using formulas
mtcars_grouped <- mtcars |> group_by_(~cyl, ~gear)

# Group using character names
mtcars |> group_by_('cyl', 'gear')

# Add grouping variables to existing groups
mtcars |>
  group_by_(~cyl) |>
  group_by_(~gear, .add = TRUE)

# Get grouping variable names
mtcars_grouped |> group_vars_()

# Get number of groups
mtcars_grouped |> n_groups_()

# Get size of each group
mtcars_grouped |> group_size_()

# Get group indices for each row
mtcars_grouped |> group_indices_()

# Get unique grouping keys
mtcars_grouped |> group_keys_()

# Get row indices for each group
mtcars_grouped |> group_rows_()

# Get complete group data
mtcars_grouped |> group_data_()

# Ungroup completely
mtcars_grouped |> ungroup_()

# Ungroup specific variables
mtcars |>
  group_by_(~cyl, ~gear, ~am) |>
  ungroup_(~gear)

# Use with other operations
mtcars |>
  group_by_(~cyl) |>
  summarise_(~mean(mpg), ~mean(hp))

}
\seealso{
\code{\link[dplyr:group_by]{dplyr::group_by()}}, \code{\link[dplyr:group_by]{dplyr::ungroup()}}, \code{\link[dplyr:group_data]{dplyr::group_vars()}},
\code{\link[dplyr:group_data]{dplyr::group_rows()}}, \code{\link[dplyr:group_data]{dplyr::group_data()}}, \code{\link[dplyr:group_data]{dplyr::group_indices()}},
\code{\link[dplyr:group_data]{dplyr::group_keys()}}, \code{\link[dplyr:group_data]{dplyr::groups()}}, \code{\link[dplyr:group_data]{dplyr::group_size()}},
\code{\link[dplyr:group_data]{dplyr::n_groups()}}, \code{\link[collapse:GRP]{collapse::fgroup_by()}}
}
